/**
 * This is a sample application program which demonstrates the data binding between the
 * XML document and the Java Objects. It instantiates the Java objects from the XML document
 * "node.xml" using the generated Java classes. The Java classes are generatd using DTD
 * ClassGenerator using the DTD file "node.dtd".
 */
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import oracle.xml.classgen.UnmarshalException;
import oracle.xml.classgen.InvalidContentException;

public class NodeLister
{
   public static void main (String args[])
   {
      Node node = null;;
      try
      {
         node = new Node();
         node = Node.unmarshal(createURL(args[0]));
         node.print(System.out);
      }
      catch (UnmarshalException u)
      {
         System.out.println("UnmarshalException thrown: " + u.toString());
         u.printStackTrace();
      }
      catch (InvalidContentException iv)
      {
         System.out.println("InvalidContentException thrown: " + iv.toString());
         iv.printStackTrace();
      }
      catch (IOException io)
      {
         System.out.println("IOException thrown: " + io.toString());
         io.printStackTrace();
      }
   }

   public static URL createURL(String fileName)
                          throws IOException
   {
      URL url = null;

      try
      {
         url = new URL(fileName);
      }
      catch (MalformedURLException ex)
      {
         File f = new File(fileName);

         try
         {
            String path = f.getAbsolutePath();
            // This is a bunch of weird code that is required to
            // make a valid URL on the Windows platform, due
            // to inconsistencies in what getAbsolutePath returns.
            String fs = System.getProperty("file.separator");
            if (fs.length() == 1)
            {
               char sep = fs.charAt(0);
               if (sep != '/')
                  path = path.replace(sep, '/');
               if (path.charAt(0) != '/')
                  path = '/' + path;
            }
            path = "file://" + path;
            url = new URL(path);
         }
         catch (MalformedURLException e)
         {
            throw new IOException(e.toString());
         }
      }

      return url;
   }

}

